timesteps = 300;    
h = 0.3;
alpha = 0.95;
h1 = h^alpha / gamma(1 + alpha);   

r = 2;
d = 0.2;
s = 0.34; %sigma
k1=0;
k2=0;
x = zeros(1, timesteps+1);
y = zeros(1, timesteps+1);
x(1) = 0.31;
y(1) = 2;

for n = 1:timesteps
    x(n+1) = x(n) + h1 * ( r*x(n) - x(n)*y(n) ) - k1*(x(n)-0.366667) - k2*(y(n)-2);
    y(n+1) = y(n) + h1 * ( s - (1/r)*y(n) - d*x(n) + x(n)*y(n) );
end

t = (0:timesteps);

figure;
subplot(2,1,1);

% Plot N(n)
plot(t, x, '.r', 'markersize',8);
xlabel('n', 'FontSize', 14, 'FontWeight','bold');
ylabel('N(n)', 'FontSize', 14, 'FontWeight','bold');
set(gca, 'LineWidth', 1.5, 'FontSize', 13, 'FontWeight','bold');

% Plot I(n)
subplot(2,1,2);
plot(t, y, '.k', 'markersize',8);
xlabel('n', 'FontSize', 14, 'FontWeight','bold');
ylabel('I(n)', 'FontSize', 14, 'FontWeight','bold');
set(gca, 'LineWidth', 1.5, 'FontSize', 13, 'FontWeight','bold');